 ; Ŀ
 ;   Dill - load any .lsp files found in C:ACAD\LOAD.                      
 ;   Copyright 1995, 2002 by Rocket Software Ltd.                          
 ;   Not named after the pickles of the same name.                         
 ; 

 ; Ŀ
 ;   Dirfe - get a list of filenames.                                      
 ;   Arguments: Pat, the file match pattern.                               
 ;              Pref, the directory to search.                             
 ;   Returns an alphabetical list of filenames with paths.                 
 ; 
 (DEFUN DIRFE (pat pref / fils num fnam nulis)
  (if (setq fils (vl-directory-files pref pat 1))
      (progn
 ; Ŀ
 ;   Put the filename list in alphabetical order.                          
 ; 
           (setq fils (acad_strlsort fils))
           (setq num 0)
           (while (and fils (setq fnam (nth num fils)))
                  (setq num (1+ num))
                  (setq fnam (strcat pref fnam))
                  (setq nulis (cons fnam nulis)))))
 (reverse nulis))
 ; Ŀ
 ;   Dirfe end.                                                            
 ; 

 ; Ŀ
 ;   Dill.                                                                 
 ; 
 (DEFUN C:DILL (/ pref flist num filnam)
  (if (and (setq pref (findfile "fang.lsp"))
           (setq pref (strcat (substr pref 1 (- (strlen pref) 8)) "load\\"))
 ; Ŀ
 ;   Get a list of the files in the directory, if any.                     
 ; 
           (setq flist (dirfe "*.lsp" pref)))
      (progn
           (setq num 0)
           (while (setq filnam (nth num flist))
                  (setq num (1+ num))
                  (load filnam))))
 (princ))